/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverestore;

import com.ibm.hwmca.base.settings.network.NetworkInfo;
import com.ibm.hwmca.base.settings.network.NetworkInterfaceInformation;
import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.fw.upgrddat.MigrateOS2Data;
import com.ibm.hwmca.fw.upgrddat.UpgradeData;
import com.ibm.hwmca.fw.upgrddat.UpgradeDataException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class UpgradeNetworkSettings
implements UpgradeData,
MigrateOS2Data {
    private static final String TRACE_MASKT = "XSETUNST";
    private static final String TRACE_MASKF = "XSETUNSF";
    private static final String TRACE_MASKD = "XSETUNSD";
    private NetworkInfo networkInfo = new NetworkInfo();
    private List ifs = new ArrayList();
    private List visibleIfs = new ArrayList();
    private NetworkInterfaceInformation netif0 = new NetworkInterfaceInformation();
    private NetworkInterfaceInformation netif1 = new NetworkInterfaceInformation();
    public static final String os2PuName = "XMRC_BASE_PU_NAME";
    public static final String os2IpNames = "XMRC_INTERNET_ADDR";
    public static final String os2NetmaskNames = "XMRC_NETWORK_MASK";
    public static final String setupCmd = "setup.cmd";
    public static final String actzroutCmd = "actzrout.cmd";
    public static final String resolv2 = "resolv2";

    public String getUpgradeDataVersion() throws UpgradeDataException {
        return "1.0";
    }

    public void saveUpgradeData(OutputStream StreamNameOut) throws UpgradeDataException {
    }

    public void restoreUpgradeData(InputStream inStream, String name) throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradeNetworkSettings.restoreUpgradeData(" + name + ")");
        try {
            int streamSize = inStream.available();
            byte[] buffer = new byte[streamSize];
            int bytesRead = inStream.read(buffer);
            Trace.trace(TRACE_MASKF, "Bytes read = " + bytesRead);
            if (bytesRead != streamSize) {
                Trace.trace(TRACE_MASKF, "Exception, Bytes read mismatch");
                UpgradeDataException exc = new UpgradeDataException("Bytes read exception, mismatch from inputstream.");
                exc.setCriticalDataError();
                throw exc;
            }
            this.networkInfo = this.getNSNetworkInfo();
            this.getNSNetworkInterfaceInformation();
            Vector TTypeVector = this.networkInfo.getTypeVector();
            Vector TDestinationVector = this.networkInfo.getDestinationVector();
            Vector TGatewayVector = this.networkInfo.getGatewayVector();
            Vector TSubnetMaskVector = this.networkInfo.getSubnetMaskVector();
            String streamRead = new String(buffer);
            StringReader sr = new StringReader(streamRead);
            BufferedReader in = new BufferedReader(sr);
            StringTokenizer tokens = new StringTokenizer("");
            boolean inIf = false;
            String lanAddr1 = "";
            String netMask1 = "";
            String type = "";
            String destination = "";
            String gateway = "";
            String subnetMask = "";
            String domain = "";
            String nameserver = "";
            if (name.endsWith(setupCmd)) {
                Trace.trace(TRACE_MASKT, "-> Process setupCmd");
                try {
                    String line;
                    do {
                        String parm;
                        if ((line = in.readLine()) == null) continue;
                        Trace.trace(TRACE_MASKF, "line read = " + line);
                        int pos = line.indexOf("ifconfig lan1");
                        if (pos != -1) {
                            tokens = new StringTokenizer(line);
                            parm = tokens.nextToken().toUpperCase();
                            if (parm.toUpperCase().equals("REM")) {
                                Trace.trace(TRACE_MASKF, "Skip lan1; it's only a comment");
                                continue;
                            }
                            if (this.visibleIfs.size() <= 0) continue;
                            int newType0 = this.netif0.getAdapterType();
                            if (this.visibleIfs.size() > 1) {
                                int newType1 = this.netif1.getAdapterType();
                                Trace.trace(TRACE_MASKT, "Two cards found; type0 = " + newType0 + " ;type1 = " + newType1);
                                boolean netMaskFound = false;
                                while (tokens.hasMoreTokens() && !netMaskFound) {
                                    parm = tokens.nextToken().toUpperCase();
                                    if (parm.equals("LAN1")) {
                                        lanAddr1 = tokens.nextToken();
                                        Trace.trace(TRACE_MASKF, "lanAddr1 = " + lanAddr1);
                                        if (newType0 == 1) {
                                            this.netif1.setIpAddress(InetAddress.getByName(lanAddr1));
                                            Trace.trace(TRACE_MASKF, "Netif0 is 1st T/R ; ");
                                            Trace.trace(TRACE_MASKF, "Set netif1 to " + lanAddr1);
                                            continue;
                                        }
                                        if (newType1 == 1) {
                                            this.netif0.setIpAddress(InetAddress.getByName(lanAddr1));
                                            Trace.trace(TRACE_MASKF, "Netif1 is 1st T/R ; ");
                                            Trace.trace(TRACE_MASKF, "Set netif0 to " + lanAddr1);
                                            continue;
                                        }
                                        this.netif1.setIpAddress(InetAddress.getByName(lanAddr1));
                                        Trace.trace(TRACE_MASKF, "No T/R found; ");
                                        Trace.trace(TRACE_MASKF, "Netif1 set to " + lanAddr1);
                                        continue;
                                    }
                                    if (!parm.equals("NETMASK")) continue;
                                    netMask1 = tokens.nextToken();
                                    Trace.trace(TRACE_MASKF, "netMask1 = " + netMask1);
                                    if (newType0 == 1) {
                                        this.netif1.setNetworkMask(InetAddress.getByName(netMask1));
                                    } else if (newType1 == 1) {
                                        this.netif0.setNetworkMask(InetAddress.getByName(netMask1));
                                    } else {
                                        this.netif1.setNetworkMask(InetAddress.getByName(netMask1));
                                    }
                                    netMaskFound = true;
                                }
                                this.putNSNetworkInterfaceInformation(this.visibleIfs);
                                continue;
                            }
                            Trace.trace(TRACE_MASKF, "lan1 parm provided, but no 2nd lan card; ignore.");
                            continue;
                        }
                        if (!line.trim().startsWith("route")) continue;
                        Trace.trace(TRACE_MASKF, "line startsWith route; line =[" + line + "]");
                        tokens = new StringTokenizer(line);
                        parm = tokens.nextToken().toUpperCase();
                        type = "";
                        destination = "";
                        gateway = "";
                        subnetMask = "";
                        boolean processingDefaultGateway = false;
                        while (tokens.hasMoreTokens()) {
                            parm = tokens.nextToken().toUpperCase();
                            if (!parm.equals("ADD")) continue;
                            type = tokens.nextToken();
                            pos = type.indexOf("-");
                            if (pos != -1) {
                                type = type.substring(pos + 1);
                            }
                            type = type.substring(0, 1).toUpperCase() + type.substring(1);
                            Trace.trace(TRACE_MASKF, "type = " + type);
                            if (type.toUpperCase().equals("DEFAULT")) {
                                gateway = tokens.nextToken();
                                Trace.trace(TRACE_MASKF, "gateway = " + gateway);
                                this.networkInfo.setDefaultGateway(gateway);
                                this.networkInfo.setGatewayDev("");
                                processingDefaultGateway = true;
                            } else {
                                destination = tokens.nextToken();
                                Trace.trace(TRACE_MASKF, "destination = " + destination);
                                gateway = tokens.nextToken();
                                Trace.trace(TRACE_MASKF, "gateway = " + gateway);
                                parm = tokens.nextToken().toUpperCase();
                                if (parm.indexOf("NETMASK") != -1) {
                                    subnetMask = tokens.nextToken();
                                    Trace.trace(TRACE_MASKF, "subnetMask = " + subnetMask);
                                }
                            }
                            if (processingDefaultGateway) continue;
                            TTypeVector.add(type);
                            TDestinationVector.add(destination);
                            TGatewayVector.add(gateway);
                            TSubnetMaskVector.add(subnetMask);
                        }
                        this.networkInfo.setTypeVector(TTypeVector);
                        this.networkInfo.setDestinationVector(TDestinationVector);
                        this.networkInfo.setGatewayVector(TGatewayVector);
                        this.networkInfo.setSubnetMaskVector(TSubnetMaskVector);
                    } while (line != null);
                }
                catch (IOException e) {
                    System.out.println("caught IOException: " + e);
                    e.printStackTrace();
                }
            } else if (name.endsWith(actzroutCmd)) {
                Trace.trace(TRACE_MASKT, "-> Process actzroutCmd");
                try {
                    String line;
                    do {
                        if ((line = in.readLine()) == null) continue;
                        Trace.trace(TRACE_MASKF, "line read = " + line);
                        int pos = line.indexOf("route");
                        if (pos == -1) continue;
                        tokens = new StringTokenizer(line);
                        String parm = tokens.nextToken().toUpperCase();
                        if (parm.toUpperCase().equals("REM")) {
                            Trace.trace(TRACE_MASKF, "Route was commented out; ignore");
                            continue;
                        }
                        type = "";
                        destination = "";
                        gateway = "";
                        subnetMask = "";
                        boolean processingDefaultGateway = true;
                        while (tokens.hasMoreTokens()) {
                            parm = tokens.nextToken().toUpperCase();
                            if (!parm.equals("ADD")) continue;
                            type = tokens.nextToken();
                            pos = type.indexOf("-");
                            if (pos != -1) {
                                type = type.substring(pos + 1);
                            }
                            type = type.substring(0, 1).toUpperCase() + type.substring(1);
                            Trace.trace(TRACE_MASKF, "type = " + type);
                            if (type.toUpperCase().equals("DEFAULT")) {
                                gateway = tokens.nextToken();
                                Trace.trace(TRACE_MASKF, "gateway = " + gateway);
                                this.networkInfo.setDefaultGateway(gateway);
                                this.networkInfo.setGatewayDev("");
                                processingDefaultGateway = true;
                            } else {
                                destination = tokens.nextToken();
                                Trace.trace(TRACE_MASKF, "destination = " + destination);
                                gateway = tokens.nextToken();
                                Trace.trace(TRACE_MASKF, "gateway = " + gateway);
                                parm = tokens.nextToken().toUpperCase();
                                if (parm.indexOf("NETMASK") != -1) {
                                    subnetMask = tokens.nextToken();
                                    Trace.trace(TRACE_MASKF, "subnetMask = " + subnetMask);
                                }
                            }
                            if (processingDefaultGateway) continue;
                            TTypeVector.add(type);
                            TDestinationVector.add(destination);
                            TGatewayVector.add(gateway);
                            TSubnetMaskVector.add(subnetMask);
                        }
                        this.networkInfo.setTypeVector(TTypeVector);
                        this.networkInfo.setDestinationVector(TDestinationVector);
                        this.networkInfo.setGatewayVector(TGatewayVector);
                        this.networkInfo.setSubnetMaskVector(TSubnetMaskVector);
                    } while (line != null);
                }
                catch (IOException e) {
                    System.out.println("caught IOException: " + e);
                    e.printStackTrace();
                }
            } else if (name.endsWith(resolv2)) {
                Trace.trace(TRACE_MASKT, "-> Process resolv2");
                try {
                    String line;
                    do {
                        String parm;
                        if ((line = in.readLine()) == null) continue;
                        Trace.trace(TRACE_MASKF, "line read = " + line);
                        int pos = line.indexOf("domain");
                        if (pos != -1) {
                            tokens = new StringTokenizer(line);
                            parm = tokens.nextToken().toUpperCase();
                            if (parm.toUpperCase().equals("REM")) {
                                Trace.trace(TRACE_MASKF, "domain was commented out; ignore");
                                continue;
                            }
                            while (tokens.hasMoreTokens()) {
                                if (parm.equals("DOMAIN")) {
                                    domain = tokens.nextToken();
                                    Trace.trace(TRACE_MASKF, "domain = " + domain);
                                    this.networkInfo.setDomainName(domain);
                                    continue;
                                }
                                parm = tokens.nextToken().toUpperCase();
                            }
                        } else {
                            pos = line.indexOf("nameserver");
                            if (pos == -1) continue;
                            tokens = new StringTokenizer(line);
                            parm = tokens.nextToken().toUpperCase();
                            if (parm.toUpperCase().equals("REM")) {
                                Trace.trace(TRACE_MASKF, "nameserver was commented out; ignore");
                                continue;
                            }
                            while (tokens.hasMoreTokens()) {
                                if (parm.equals("NAMESERVER")) {
                                    nameserver = tokens.nextToken();
                                    Trace.trace(TRACE_MASKF, "nameserver = " + nameserver);
                                    continue;
                                }
                                parm = tokens.nextToken().toUpperCase();
                            }
                        }
                    } while (line != null);
                }
                catch (IOException e) {
                    System.out.println("caught IOException: " + e);
                    e.printStackTrace();
                }
            }
            this.putNSNetworkInfo(this.networkInfo);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "Exception, UpgradeNetworkSettings.restoreUpgradeData() = " + exc);
            UpgradeDataException udexc = new UpgradeDataException(exc);
            udexc.setCriticalDataError();
            throw udexc;
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeNetworkSettings.restoreUpgradeData");
    }

    public void restoreOS2Data(Object obj, String name) throws UpgradeDataException {
        Trace.trace(TRACE_MASKT, "-> UpgradeNetworkSettings.restoreOS2Data, SIMField = [" + name + "]");
        try {
            byte[] buffer = (byte[])obj;
            this.networkInfo = this.getNSNetworkInfo();
            Trace.trace(TRACE_MASKT, "Got networkInfo object");
            this.getNSNetworkInterfaceInformation();
            Trace.trace(TRACE_MASKT, "ifs.size() = " + this.ifs.size());
            if (name.equals(os2PuName)) {
                Trace.trace(TRACE_MASKT, "-> Process XMRC_BASE_PU_NAME");
                String basePUName = new String(buffer).trim();
                Trace.trace(TRACE_MASKT, "basePUName = [" + basePUName + "]");
                this.networkInfo.setComputerName(basePUName);
                Trace.trace(TRACE_MASKT, "<- End Process XMRC_BASE_PU_NAME");
            } else if (name.equals(os2IpNames)) {
                Trace.trace(TRACE_MASKT, "-> Process XMRC_INTERNET_ADDR");
                String lanAddr0 = UpgradeNetworkSettings.IPtoString(buffer, 0);
                String lanAddr1 = "";
                int oldType0 = 1;
                int oldType1 = 0;
                int numOldAddrs = 1;
                Trace.trace(TRACE_MASKT, "lanAddr0 = " + lanAddr0 + "; oldType0 = " + oldType0);
                int bytesRead = buffer.length;
                if (bytesRead > 4) {
                    lanAddr1 = UpgradeNetworkSettings.IPtoString(buffer, 4);
                    oldType1 = 2;
                    numOldAddrs = 2;
                }
                Trace.trace(TRACE_MASKT, "lanAddr1 = " + lanAddr1 + "; oldType1 = " + oldType1);
                int numNewCards = this.visibleIfs.size();
                int newType0 = 0;
                int newType1 = 0;
                if (numNewCards == 1) {
                    this.netif0.setIpAddress(InetAddress.getByName(lanAddr0));
                    newType0 = this.netif0.getAdapterType();
                    Trace.trace(TRACE_MASKT, "One card found; type = " + newType0 + ";  IpAddress = " + lanAddr0);
                } else if (numNewCards < 1) {
                    Trace.trace(TRACE_MASKT, "No lan cards found; ignore old addresses");
                } else {
                    newType0 = this.netif0.getAdapterType();
                    newType1 = this.netif1.getAdapterType();
                    Trace.trace(TRACE_MASKT, "Two cards found; type0 = " + newType0 + " ;type1 = " + newType1);
                    if (newType0 == 1) {
                        this.netif0.setIpAddress(InetAddress.getByName(lanAddr0));
                        this.netif1.setIpAddress(InetAddress.getByName(lanAddr1));
                        Trace.trace(TRACE_MASKF, "Netif0 is 1st T/R ; " + lanAddr0);
                        Trace.trace(TRACE_MASKF, "Netif1 set to " + lanAddr1);
                    } else if (newType1 == 1) {
                        this.netif1.setIpAddress(InetAddress.getByName(lanAddr0));
                        this.netif0.setIpAddress(InetAddress.getByName(lanAddr1));
                        Trace.trace(TRACE_MASKF, "Netif1 is 1st T/R ; " + lanAddr0);
                        Trace.trace(TRACE_MASKF, "Netif0 set to " + lanAddr1);
                    } else {
                        this.netif0.setIpAddress(InetAddress.getByName(lanAddr0));
                        this.netif1.setIpAddress(InetAddress.getByName(lanAddr1));
                        Trace.trace(TRACE_MASKF, "No T/R found; Netif0 set to " + lanAddr0);
                        Trace.trace(TRACE_MASKF, "Netif1 set to " + lanAddr1);
                    }
                }
                Trace.trace(TRACE_MASKT, "<- End Process XMRC_INTERNET_ADDR");
            } else if (name.equals(os2NetmaskNames)) {
                Trace.trace(TRACE_MASKT, "-> Process XMRC_NETWORK_MASK");
                String netMask0 = UpgradeNetworkSettings.IPtoString(buffer, 0);
                String netMask1 = "";
                boolean oldType0 = true;
                int oldType1 = 0;
                int numOldAddrs = 1;
                int bytesRead = buffer.length;
                if (bytesRead > 4) {
                    netMask1 = UpgradeNetworkSettings.IPtoString(buffer, 4);
                    oldType1 = 2;
                    numOldAddrs = 2;
                }
                int numNewCards = this.visibleIfs.size();
                int newType0 = 0;
                int newType1 = 0;
                if (numNewCards == 1) {
                    this.netif0.setNetworkMask(InetAddress.getByName(netMask0));
                    newType0 = this.netif0.getAdapterType();
                    Trace.trace(TRACE_MASKT, "One card found; type = " + newType0 + ";  NetworkMask = " + netMask0);
                } else if (numNewCards < 1) {
                    Trace.trace(TRACE_MASKT, "No lan cards found; ignore old netmasks");
                } else {
                    newType0 = this.netif0.getAdapterType();
                    newType1 = this.netif1.getAdapterType();
                    Trace.trace(TRACE_MASKT, "Two cards found; type0 = " + newType0 + " ;type1 = " + newType1);
                    if (newType0 == 1) {
                        this.netif0.setNetworkMask(InetAddress.getByName(netMask0));
                        this.netif1.setNetworkMask(InetAddress.getByName(netMask1));
                        Trace.trace(TRACE_MASKF, "Netif0 is 1st T/R ; " + netMask0);
                        Trace.trace(TRACE_MASKF, "Netif1 set to " + netMask1);
                    } else if (newType1 == 1) {
                        this.netif1.setNetworkMask(InetAddress.getByName(netMask0));
                        this.netif0.setNetworkMask(InetAddress.getByName(netMask1));
                        Trace.trace(TRACE_MASKF, "Netif1 is 1st T/R ; " + netMask0);
                        Trace.trace(TRACE_MASKF, "Netif0 set to " + netMask1);
                    } else {
                        this.netif0.setNetworkMask(InetAddress.getByName(netMask0));
                        this.netif1.setNetworkMask(InetAddress.getByName(netMask1));
                        Trace.trace(TRACE_MASKF, "No T/R found; Netif0 set to " + netMask0);
                        Trace.trace(TRACE_MASKF, "Netif1 set to " + netMask1);
                    }
                }
                Trace.trace(TRACE_MASKT, "<- End Process XMRC_NETWORK_MASK");
            }
            this.putNSNetworkInterfaceInformation(this.visibleIfs);
            this.putNSNetworkInfo(this.networkInfo);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "Exception, UpgradeNetworkSettings.restoreOS2Data() = " + exc);
            UpgradeDataException udexc = new UpgradeDataException(exc);
            udexc.setCriticalDataError();
            throw udexc;
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeNetworkSettings.restoreOS2Data");
    }

    private NetworkInfo getNSNetworkInfo() {
        this.networkInfo = NetworkSettings.getNetworkSettings().getNetworkInfo();
        Trace.trace(TRACE_MASKT, "Got networkInfo object");
        return this.networkInfo;
    }

    private void putNSNetworkInfo(NetworkInfo _networkInfo) {
        Trace.trace(TRACE_MASKT, "-> putNSNetworkInfo");
        NetworkSettings.getNetworkSettings().applyNetworkSettings(_networkInfo);
        Trace.trace(TRACE_MASKT, "<- putNSNetworkInfo");
    }

    private void getNSNetworkInterfaceInformation() {
        this.ifs = NetworkSettings.getNetworkSettings().getNetworkInterfaceInfo();
        this.visibleIfs = NetworkSettings.getNetworkSettings().getVisibleIfs();
        Trace.trace(TRACE_MASKT, "ifs.size() = " + this.ifs.size() + "; visibleIfs.size() = " + this.visibleIfs.size());
        if (this.visibleIfs.size() > 0) {
            this.netif0 = (NetworkInterfaceInformation)this.visibleIfs.get(0);
            if (this.visibleIfs.size() > 1) {
                this.netif1 = (NetworkInterfaceInformation)this.visibleIfs.get(1);
            }
        }
    }

    private void putNSNetworkInterfaceInformation(List visible_ifs) {
        Trace.trace(TRACE_MASKT, "-> putNSNetworkInterfaceInformation " + visible_ifs.size());
        if (visible_ifs.size() > 0) {
            Trace.trace(TRACE_MASKT, "Replace the 1st");
            visible_ifs.set(0, this.netif0);
        }
        if (visible_ifs.size() > 1) {
            Trace.trace(TRACE_MASKT, "Must have had 2 lan cards. Copy the 2nd");
            visible_ifs.set(1, this.netif1);
        } else {
            Trace.trace(TRACE_MASKT, "Don't update the 2nd element - doesn't exist");
        }
        NetworkSettings.getNetworkSettings().setVisibleIfs(visible_ifs);
        Trace.trace(TRACE_MASKT, "<- putNSNetworkInterfaceInformation");
    }

    public static final String IPtoString(byte[] address, int offset) {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(address[offset + 0] & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(address[offset + 1] & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(address[offset + 2] & 0xFF);
        stringBuffer.append('.');
        stringBuffer.append(address[offset + 3] & 0xFF);
        return stringBuffer.toString();
    }
}

